/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.executor.Executor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;

public class WorldDataHandler {
    private final Executor renderExecutor;
    private WorldDataReader reader;
    private class_3218 worldServer;
    private Path worldDir;
    private static Field loadedCapabilityField = null;

    public WorldDataHandler(WorldDataReader reader, Executor renderExecutor) throws NoSuchFieldException, SecurityException {
        this.reader = reader;
        this.renderExecutor = renderExecutor;
        if (loadedCapabilityField == null) {
            loadedCapabilityField = class_3218.class.getDeclaredField("xaero_wm_loadedCapability");
        }
    }

    public void handleRenderExecutor() {
        this.renderExecutor.method_5383();
    }

    public void prepareSingleplayer(class_1937 world, MapProcessor mapProcessor) {
        String worldId = mapProcessor.getCurrentWorldId();
        if (world != null && !mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(worldId), worldId)) {
            this.worldServer = class_310.method_1551().method_1576().method_3847(world.method_27983());
            if (this.worldServer != null) {
                Path overworldDir = this.worldServer.method_8503().method_27050(class_5218.field_24188);
                this.worldDir = class_2874.method_12488((class_5321)this.worldServer.method_27983(), (Path)overworldDir);
            } else {
                this.worldDir = null;
            }
        } else {
            this.worldServer = null;
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, class_1937 world, boolean loading, int[] chunkCountDest) throws IOException {
        ServerWorldLoaded loadedCap;
        if (this.worldServer == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        try {
            loadedCap = (ServerWorldLoaded)loadedCapabilityField.get(this.worldServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        boolean shouldCancel = false;
        ServerWorldLoaded serverWorldLoaded = loadedCap;
        synchronized (serverWorldLoaded) {
            if (loadedCap.loaded) {
                boolean buildResult = this.reader.buildRegion(region, this.worldServer, world, loading, chunkCountDest, this.renderExecutor);
                Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                return result;
            }
            shouldCancel = true;
        }
        if (shouldCancel) {
            WorldMap.LOGGER.info("Tried loading a region for an unloaded server world!");
            return Result.CANCEL;
        }
        WorldMap.LOGGER.info("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(class_3218 sw) {
        ServerWorldLoaded loadedCap;
        if (loadedCapabilityField == null) {
            return;
        }
        try {
            loadedCap = (ServerWorldLoaded)loadedCapabilityField.get(sw);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ServerWorldLoaded serverWorldLoaded = loadedCap;
        synchronized (serverWorldLoaded) {
            loadedCap.loaded = false;
        }
    }

    public class_3218 getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.reader;
    }

    public Path getWorldDir() {
        return this.worldDir;
    }

    Executor getWorldDataRenderExecutor() {
        return this.renderExecutor;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

